<?php
session_start();
require_once 'config.php';
require_once 'includes/db.php';
require_once 'includes/auth.php';

if (isset($_SESSION['user_id'])) {
    header('Location: profile.php');
    exit;
}

// Генерация 4-значной числовой капчи (только цифры)
if (!isset($_SESSION['captcha'])) {
    $_SESSION['captcha'] = rand(1000, 9999);
}

$csrf_token = generate_csrf_token(); // Генерация CSRF-токена
$success = false; // Флаг для отображения сообщения об успехе

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Проверка CSRF-токена
    if (!verify_csrf_token()) {
        $error = "Недействительный запрос. Попробуйте снова.";
    } else {
        $login = trim($_POST['login'] ?? '');
        $password = $_POST['password'] ?? '';
        $confirm_password = $_POST['confirm_password'] ?? '';
        $captcha_input = $_POST['captcha'] ?? '';

        if (!empty($login) && !empty($password) && !empty($confirm_password) && !empty($captcha_input)) {
            if ($password !== $confirm_password) {
                $error = "Пароли не совпадают.";
            } elseif ((int)$captcha_input !== $_SESSION['captcha']) {
                $error = "Неверный код капчи.";
            } else {
                try {
                    global $pdo;
                    $stmt = $pdo->prepare("SELECT COUNT(*) FROM users WHERE login = ?");
                    $stmt->execute([$login]);
                    if ($stmt->fetchColumn() > 0) {
                        $error = "Пользователь с таким логином уже существует.";
                    } else {
                        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                        $stmt = $pdo->prepare("INSERT INTO users (login, password) VALUES (?, ?)");
                        if ($stmt->execute([$login, $hashed_password])) {
                            // Получаем ID нового пользователя для авторизации
                            $stmt = $pdo->prepare("SELECT id FROM users WHERE login = ?");
                            $stmt->execute([$login]);
                            $user = $stmt->fetch(PDO::FETCH_ASSOC);
                            
                            if ($user) {
                                $_SESSION['user_id'] = $user['id'];
                                $_SESSION['is_admin'] = false; // Новый пользователь не администратор по умолчанию
                                unset($_SESSION['captcha']); // Сброс капчи
                                $success = true; // Устанавливаем флаг успеха для отображения сообщения
                            } else {
                                $error = "Ошибка идентификации нового пользователя.";
                            }
                        } else {
                            $error = "Ошибка регистрации. Попробуйте позже.";
                        }
                    }
                } catch (PDOException $e) {
                    error_log("Ошибка регистрации: " . $e->getMessage());
                    $error = "Произошла ошибка. Обратитесь к администратору.";
                }
            }
        } else {
            $error = "Заполните все поля, включая код капчи.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="assets/css/style.css">
    <title>Регистрация — AstralForge</title>
</head>
<body>
    <div class="container">
        <h1>Регистрация в AstralForge</h1>
        <?php if (isset($error)): ?>
            <p style="color: #e74c3c;"><?php echo htmlspecialchars($error); ?></p>
        <?php elseif ($success): ?>
            <p style="color: #2ecc71;">Регистрация успешна! Вы будете перенаправлены в ваш профиль...</p>
            <script>
                // Перенаправление в профиль через 2 секунды
                setTimeout(function() {
                    window.location.href = "profile.php";
                }, 2000);
            </script>
        <?php endif; ?>
        <form method="POST" class="profile-form">
            <div class="profile-details">
                <div class="form-group">
                    <label for="login" class="info-label">Логин:</label>
                    <input type="text" id="login" name="login" class="info-value" placeholder="Введите логин" required>
                </div>
                <div class="form-group">
                    <label for="password" class="info-label">Пароль:</label>
                    <input type="password" id="password" name="password" class="info-value" placeholder="Введите пароль" required>
                </div>
                <div class="form-group">
                    <label for="confirm_password" class="info-label">Подтвердите пароль:</label>
                    <input type="password" id="confirm_password" name="confirm_password" class="info-value" placeholder="Подтвердите пароль" required>
                </div>
                <div class="form-group">
                    <label for="captcha" class="info-label">Код капчи (<?php echo $_SESSION['captcha']; ?>):</label>
                    <input type="number" id="captcha" name="captcha" class="info-value" placeholder="Введите код" required>
                </div>
                <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">
                <button type="submit" class="chat-button">Зарегистрироваться</button>
                <p>Уже есть аккаунт? <a href="login.php" class="info-link">Войти</a></p>
            </div>
        </form>
    </div>
</body>
</html>