<?php
// Включение отображения ошибок для отладки (убрать на продакшене)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Проверка, была ли сессия уже запущена
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once 'config.php';
require_once 'includes/db.php';
require_once 'includes/auth.php';

// Проверка авторизации
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

global $pdo;
$stmt = $pdo->query("SELECT id, login, avatar, name FROM users ORDER BY id DESC");
$users = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="assets/css/style.css">
    <title>Список пользователей</title>
</head>
<body>
    <div class="container">
        <h1>Список пользователей</h1>
        <div class="users-list">
            <?php if (count($users) > 0): ?>
                <?php foreach ($users as $user): ?>
                    <div class="user-card">
                        <a href="user_profile.php?id=<?php echo htmlspecialchars($user['id']); ?>">
                            <img src="<?php echo htmlspecialchars($user['avatar'] ?? 'assets/uploads/default-avatar.png'); ?>" alt="<?php echo htmlspecialchars($user['login']); ?>" class="user-avatar" onerror="this.src='assets/uploads/default-avatar.png';">
                            <p><?php echo htmlspecialchars($user['login']) . ($user['name'] ? ' (' . htmlspecialchars($user['name']) . ')' : ''); ?></p>
                        </a>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p>Нет зарегистрированных пользователей.</p>
            <?php endif; ?>
        </div>
        <a href="index.php">На главную</a>
    </div>
</body>
</html>