# MyTaskium 1.0

**MyTaskium** — это лёгкий и автономный менеджер задач, написанный на **PHP**, не требующий базы данных.  
Приложение предназначено для личного использования или небольших команд, которым нужен быстрый и надёжный способ вести список дел, архивировать завершённые задачи и работать локально без сторонних сервисов.

![Скриншот](https://github.com/Larin-Konstantin/MyTaskium/blob/main/screen.png)

---

##  Возможности

- Добавление, редактирование и удаление задач  
- Архивирование завершённых задач  
- Указание сроков выполнения (дедлайнов)  
- Назначение исполнителя  
- Простая защита паролем  
- Хранение данных в JSON-файлах  
- Полностью автономная работа без базы данных  
- Минималистичный PHP-бэкенд (один файл `index.php`)  

---

## Структура данных

Все данные сохраняются в папке `/data/`:
```
/data/
 ├─ tasks.json     # активные задачи
 ├─ archive.json   # завершённые задачи
 └─ error.log      # журнал ошибок
```

Каждая задача содержит поля:
```json
{
  "id": "6731a1dce15f2",
  "title": "Подготовить отчёт",
  "deadline": "2025-10-20",
  "status": "Надо сделать",
  "executor": "ЛАРИН",
  "created": "2025-10-11",
  "closed": null
}
```

---

## Установка и запуск

Скачать или клонировать на локальный сервер или хостинг в любую удобную папку.
Минимальная версия PHP > 7.4
Программа протестирована и работает на версии 8.2

## Авторизация

Пароль по умолчанию задаётся в `index.php`:
```php
const PASSWORD = 'pass123';
```
Измените его на свой собственный.

---

## Лицензия

Проект распространяется под лицензией **MIT** — свободно используй, модифицируй и развивай.

---

##  Идея проекта

MyTaskium создавался как **простая альтернатива громоздким менеджерам задач** — без БД, зависимостей и регистрации.  
Он идеально подходит для:
- личных TODO-списков,  
- небольших рабочих журналов,  
- проектов, где важна автономность и простота.



Все вопросы на электронную почту: kontrkonst@gmail.com