@extends('layout')

@section('title', $offer->title)

@section('header')
    <div class="float-end">
        @if (getUser())
            @if (in_array($offer->status, ['wait', 'process']) && getUser('id') === $offer->user_id)
                <a class="btn btn-success" title="{{ __('main.edit') }}" href="{{ route('offers.edit', ['id' => $offer->id]) }}">{{ __('main.change') }}</a>
            @endif

            @if (isAdmin())
                <a class="btn btn-light" href="{{ route('admin.offers.view', ['id' => $offer->id]) }}"><i class="fas fa-wrench"></i></a>
            @endif
        @endif
    </div>

    <h1>{{ $offer->title }}</h1>
@stop

@section('breadcrumb')
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="{{ route('offers.index', ['type' => $offer->type]) }}">{{ __('index.offers') }}</a></li>
            <li class="breadcrumb-item active">{{ $offer->title }}</li>
        </ol>
    </nav>
@stop

@section('content')
    <div class="mb-3">
        <div class="section-content">
            <div class="section-message">
                {{ bbCode($offer->text) }}
            </div>
        </div>

        <div class="section-body">
            {{ __('main.added') }}: {{ $offer->user->getProfile() }}
            <small class="section-date text-muted fst-italic">{{ dateFixed($offer->created_at) }}</small>

            <div class="my-3">
                {{ $offer->getStatus() }}
            </div>

            <div class="js-rating">
                {{ __('main.rating') }}:
                @if (getUser() && getUser('id') !== $offer->user_id)
                    <a class="post-rating-down{{ $offer->vote === '-' ? ' active' : '' }}" href="#" onclick="return changeRating(this);" data-id="{{ $offer->id }}" data-type="{{ $offer->getMorphClass() }}" data-vote="-" data-token="{{ csrf_token() }}"><i class="fa fa-arrow-down"></i></a>
                @endif
                <b>{{ formatNum($offer->rating) }}</b>
                @if (getUser() && getUser('id') !== $offer->user_id)
                    <a class="post-rating-up{{ $offer->vote === '+' ? ' active' : '' }}" href="#" onclick="return changeRating(this);" data-id="{{ $offer->id }}" data-type="{{ $offer->getMorphClass() }}" data-vote="+" data-token="{{ csrf_token() }}"><i class="fa fa-arrow-up"></i></a>
                @endif
            </div>
        </div>
    </div>

    @if ($offer->reply)
        <div class="section mb-3 shadow">
            <h5>{{ __('offers.official_response') }}</h5>
            <div class="section-message">
                {{ bbCode($offer->reply) }}<br>
                {{ $offer->replyUser->getProfile() }}
                <small class="section-date text-muted fst-italic">{{ dateFixed($offer->updated_at) }}</small>
            </div>
        </div>
    @endif

    @if ($offer->lastComments->isNotEmpty())
        <h5><i class="fa fa-comment"></i> {{ __('main.last_comments') }}</h5>

        @foreach ($offer->lastComments(5)->get() as $comment)
            <div class="section mb-3 shadow">
                <div class="user-avatar">
                    {{ $comment->user->getAvatar() }}
                    {{ $comment->user->getOnline() }}
                </div>

                <div class="section-user d-flex align-items-start">
                    <div class="flex-grow-1">
                        {{ $comment->user->getProfile() }}

                        <small class="section-date text-muted fst-italic">{{ dateFixed($comment->created_at) }}</small><br>
                        <small class="fst-italic">{{ $comment->user->getStatus() }}</small>
                    </div>
                </div>

                <div class="section-body border-top">
                    <div class="section-message">
                        {{ bbCode($comment->text) }}<br>
                        @if (isAdmin())
                            <div class="small text-muted fst-italic mt-2">{{ $comment->brow }}, {{ $comment->ip }}</div>
                        @endif
                    </div>
                </div>
            </div>
        @endforeach

        <div class="p-3 mb-3 shadow">
            <i class="fas fa-comments"></i> <b><a href="{{ route('offers.comments', ['id' => $offer->id]) }}">{{ __('main.all_comments') }}</a></b> <span class="badge bg-adaptive">{{ $offer->count_comments }}</span>
        </div>
    @endif

    @if (! $offer->closed)
        @if ($offer->lastComments->isEmpty())
            {{ showError(__('main.empty_comments')) }}
        @endif

        @if (getUser())
            <div class="section-form mb-3 shadow">
                <form action="{{ route('offers.comments', ['id' => $offer->id]) }}" method="post">
                    @csrf
                    <div class="mb-3{{ hasError('msg') }}">
                        <label for="msg" class="form-label">{{ __('main.message') }}:</label>
                        <textarea class="form-control markItUp" maxlength="{{ setting('comment_text_max') }}" id="msg" rows="5" name="msg" required>{{ getInput('msg') }}</textarea>
                        <div class="invalid-feedback">{{ textError('msg') }}</div>
                        <span class="js-textarea-counter"></span>
                    </div>

                    <button class="btn btn-primary">{{ __('main.write') }}</button>
                </form>
            </div>

            <a href="/rules">{{ __('main.rules') }}</a> /
            <a href="/stickers">{{ __('main.stickers') }}</a> /
            <a href="/tags">{{ __('main.tags') }}</a><br><br>
        @else
            {{ showError(__('main.closed_comments')) }}
        @endif
    @else
        {{ showError(__('main.not_authorized')) }}
    @endif
@stop
